#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    double x, y;
    int index;
} Point;

int cmp_x(const void *a, const void *b) {
    Point *p1 = (Point*)a;
    Point *p2 = (Point*)b;
    if (p1->x < p2->x) return -1;
    if (p1->x > p2->x) return 1;
    return 0;
}

int main() {
    int n;
    double eps;
    scanf("%d %lf", &n, &eps);

    Point *points = (Point*)malloc(n * sizeof(Point));
    for (int i = 0; i < n; i++) {
        scanf("%lf %lf", &points[i].x, &points[i].y);
        points[i].index = i + 1; // 1-based indexing
    }

    int grid_size = (int)ceil(1.0 / eps);
    Point **grid = (Point**)calloc(grid_size * grid_size, sizeof(Point*));

    int *used = (int*)calloc(n, sizeof(int));
    int q_size = 0;

    for (int i = 0; i < n; i++) {
        int gx = (int)(points[i].x / eps);
        int gy = (int)(points[i].y / eps);
        int gid = gx * grid_size + gy;
        if (!grid[gid]) {
            grid[gid] = &points[i];
            used[i] = 1;
            q_size++;
        }
    }

    printf("%d\n", q_size);

    // Ispis indeksa izabranih tacaka
    for (int i = 0; i < n; i++) {
        if (used[i]) printf("%d ", i + 1);
    }
    printf("\n");

    // Sada pravimo jednostavno stabilo: spajamo izabrane tacke po redu
    Point *Q = (Point*)malloc(q_size * sizeof(Point));
    int idx = 0;
    for (int i = 0; i < n; i++) {
        if (used[i]) Q[idx++] = points[i];
    }

    // Sortiramo po x koordinati radi jednostavnog spajanja
    qsort(Q, q_size, sizeof(Point), cmp_x);

    for (int i = 0; i < q_size - 1; i++) {
        printf("%d %d\n", Q[i].index, Q[i+1].index);
    }

    free(points);
    free(grid);
    free(used);
    free(Q);

    return 0;
}